// const express = require("express");
// const cors = require("cors");
// const bodyParser = require("body-parser");
// const mysql = require("mysql2/promise");
// const path = require("path");
// const multer = require("multer");
// const fs = require("fs");
// const mime = require("mime-types"); // Add this line

// const app = express();

// app.use(bodyParser.json());
// app.use(bodyParser.urlencoded({ extended: false }));
// app.use(cors());
// app.use(express.json());

// // Serve static files from the 'images' directory
// app.use("/images", express.static(path.join(__dirname, "images")));

// const pool = mysql.createPool({
//   host: "localhost",
//   user: "root",
//   password: "",
//   database: "popin",
//   waitForConnections: true,
//   connectionLimit: 10,
//   queueLimit: 0,
// });

// // Update the storage configuration for multer
// const storage = multer.diskStorage({
//   destination: (req, file, cb) => {
//     // All images will be stored in the 'images' folder
//     cb(null, path.join(__dirname, "images"));
//   },
//   filename: (req, file, cb) => {
//     cb(null, Date.now() + "-" + file.originalname);
//   },
// });

// const upload = multer({ storage: storage });
// // Create a transporter using your working configuration


// app.listen(3000, () => console.log("Server running on port 3000"));


const express = require("express");
const cors = require("cors");
const bodyParser = require("body-parser");
const mysql = require("mysql2/promise");
const path = require("path");
const multer = require("multer");
const fs = require("fs");
const mime = require("mime-types");

const app = express();

app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: false }));
app.use(cors());
app.use(express.json());

// Serve static files from the 'images' directory
app.use("/images", express.static(path.join(__dirname, "images")));

const pool = mysql.createPool({
  host: "localhost",
  user: "root",
  password: "",
  database: "popin",
  waitForConnections: true,
  connectionLimit: 10,
  queueLimit: 0,
});

// Update the storage configuration for multer
const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    // All images will be stored in the 'images' folder
    cb(null, path.join(__dirname, "images"));
  },
  filename: (req, file, cb) => {
    cb(null, Date.now() + "-" + file.originalname);
  },
});

const upload = multer({ storage: storage });

// API endpoint to get all stock items
app.get("/api/stock", async (req, res) => {
  try {
    const [rows] = await pool.query("SELECT * FROM stock");
    res.json(rows);
  } catch (error) {
    console.error("Error fetching stock:", error);
    res.status(500).json({ error: "Internal server error" });
  }
});

// API endpoint to add a new stock item
app.post("/api/stock", upload.single("image"), async (req, res) => {
  const { name, price, amount } = req.body;
  const image = req.file ? `/images/${req.file.filename}` : null;

  try {
    const [result] = await pool.query(
      "INSERT INTO stock (name, price, amount, image) VALUES (?, ?, ?, ?)",
      [name, price, amount, image]
    );
    res.status(201).json({ id: result.insertId, name, price, amount, image });
  } catch (error) {
    console.error("Error adding stock:", error);
    res.status(500).json({ error: "Internal server error" });
  }
});

// API endpoint to update a stock item
app.put("/api/stock/:id", upload.single("image"), async (req, res) => {
  const { id } = req.params;
  const { name, price, amount } = req.body;
  const image = req.file ? `/images/${req.file.filename}` : null;

  try {
    let query = "UPDATE stock SET name = ?, price = ?, amount = ?";
    let params = [name, price, amount];

    if (image) {
      query += ", image = ?";
      params.push(image);
    }

    query += " WHERE id = ?";
    params.push(id);

    await pool.query(query, params);
    res.json({ id, name, price, amount, image });
  } catch (error) {
    console.error("Error updating stock:", error);
    res.status(500).json({ error: "Internal server error" });
  }
});

// API endpoint to delete a stock item
app.delete("/api/stock/:id", async (req, res) => {
  const { id } = req.params;

  try {
    await pool.query("DELETE FROM stock WHERE id = ?", [id]);
    res.status(204).end();
  } catch (error) {
    console.error("Error deleting stock:", error);
    res.status(500).json({ error: "Internal server error" });
  }
});

app.listen(3000, () => console.log("Server running on port 3000"));
